/*
    Summary: ceill.c
    *Libc implementation of ceill*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <float.h>
#include <math.h>
#include <stdint.h>

/* Function: ceill
 * gets and returns the integer value of x when rounded up.
 */
long double ceill(long double x)
{
    long double copy = truncl(x);
    if (copy < x) return (copy + 1);
    return(copy);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( ceill(0) == 0 );
    TESTCASE( ceill(1.0) == 1 );
    TESTCASE( ceill(5.1) == 6 );
    TESTCASE( ceill(9.999) == 10 );
    TESTCASE( ceill(-1.0) == -1 );
    TESTCASE( ceill(-5.1) == -5 );
    TESTCASE( ceill(-9.999) == -9 );
    return TEST_RESULTS;
}

#endif
