/*
    Summary: floor.c
    *Libc implementation of floor*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <float.h>
#include <math.h>

/* Function: floor
 * gets and returns the integer value of x when rounded down.
 */
double floor(double x)
{
    double copy = trunc(x);
    if (copy > x) return (copy - 1);
    return(copy);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( floor(0) == 0 );
    TESTCASE( floor(1.0) == 1 );
    TESTCASE( floor(5.1) == 5 );
    TESTCASE( floor(9.999) == 9 );
    TESTCASE( floor(-1.0) == -1 );
    TESTCASE( floor(-5.1) == -6 );
    TESTCASE( floor(-9.999) == -10 );
    return TEST_RESULTS;
}

#endif
