/*
    Summary: floorf.c
    *Libc implementation of floorf*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <float.h>
#include <math.h>

/* Function: floorf
 * gets and returns the integer value of x when rounded down.
 */
float floorf(float x)
{
    float copy = trunc(x);
    if (copy > x) return (copy - 1);
    return(copy);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( floorf(0) == 0 );
    TESTCASE( floorf(1.0) == 1 );
    TESTCASE( floorf(5.1) == 5 );
    TESTCASE( floorf(9.999) == 9 );
    TESTCASE( floorf(-1.0) == -1 );
    TESTCASE( floorf(-5.1) == -6 );
    TESTCASE( floorf(-9.999) == -10 );
    return TEST_RESULTS;
}

#endif
