/*
    Summary: floorl.c
    *Libc implementation of floorl*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <float.h>
#include <math.h>

/* Function: floorl
 * gets and returns the integer value of x when rounded down.
 */
long double floorl(long double x)
{
    long double copy = truncl(x);
    if (copy > x) return (copy - 1);
    return(copy);
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( floorl(0) == 0 );
    TESTCASE( floorl(1.0) == 1 );
    TESTCASE( floorl(5.1) == 5 );
    TESTCASE( floorl(9.999) == 9 );
    TESTCASE( floorl(-1.0) == -1 );
    TESTCASE( floorl(-5.1) == -6 );
    TESTCASE( floorl(-9.999) == -10 );
    return TEST_RESULTS;
}

#endif
