/*
    Summary: sqrt.c
    *Libc implementation of sqrt*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */


#include <math.h>

#define iterations 31

double sqrt(double x)
{
    if (x < 0) return NAN;

    double d = (x > 1) ? x : 1;
    double a = 0;
    int n;
    for (n = 0; n < iterations; n++)
    {
        if (a * a > x)
        {
            a -= d;
            d *= 0.5;
        }
        else if (a * a < x)
        {
            a += d;
            d *= 0.5;
        }
        else return a;
    }
    return a;
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( NO_TESTDRIVER );
    return TEST_RESULTS;
}

#endif
