/*
    Summary: tan.c
    *Libc implementation of tan*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <math.h>

/* Function: tan
 * computes the tangent of angle x
 */
double tan(double x)
{
    x = _PDCLIB_clampradd(x);
    return (sin(x) / cos(x));
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( NO_TESTDRIVER );
    return TEST_RESULTS;
}

#endif
