/*
    Summary: tanf.c
    *Libc implementation of tanf*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <math.h>

/* Function: tanf
 * computes the tangent of angle x
 */
float tanf(float x)
{
    x = _PDCLIB_clampradf(x);
    return (sinf(x) / cosf(x));
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( NO_TESTDRIVER );
    return TEST_RESULTS;
}

#endif
