/*
    Summary: tanl.c
    *Libc implementation of tanl*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <math.h>

/* Function: tanl
 * computes the tangent of angle x
 */
long double tanl(long double x)
{
    x = _PDCLIB_clampradl(x);
    return (sinl(x) / cosl(x));
}

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    BEGIN_TESTS;
    TESTCASE( NO_TESTDRIVER );
    return TEST_RESULTS;
}

#endif
