/*
    Summary: clampradd.c
    *Definition of domain clipping tools*

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <math.h>

#define PI 3.1415926535897932384626433832795028841971L

static double _PDCLIB_doclamppd(double x, double clamp);
static double _PDCLIB_doclampnd(double x, double clamp);

/* Function: _PDCLIB_doclamppd
 * recursively shift x into the domain [0,clamp]
 */
static double _PDCLIB_doclamppd(double x, double clamp)
{
    if (clamp < x) x = _PDCLIB_doclamppd(x, clamp * 2);
    if (clamp < x) x -= clamp;
    return(x);
}

/* Function: _PDCLIB_doclampnd
 * recursively shift x into the domain [-clamp,0]
 */
static double _PDCLIB_doclampnd(double x, double clamp)
{
    if (clamp > x) x = _PDCLIB_doclampnd(x, clamp * 2);
    if (clamp > x) x -= clamp;
    return(x);

}

/* Function: _PDCLIB_clampradd
 * ensure x is in the range [-pi,pi], otherwise shift the domain into position
 */
double _PDCLIB_clampradd(double x)
{
    if (x > PI)
    {
        x = _PDCLIB_doclamppd(x, 2 * PI);
        if (x > PI) x -= (2 * PI);
        return(x);
    } else if (x < -PI) {
        x = _PDCLIB_doclampnd(x, -2 * PI);
        if (x < -PI) x += (2 * PI);
        return(x);
    } else {
        return(x);
    }
}

#ifdef TEST
#include <_PDCLIB_test.h>

#define MARGIN 0.000001L
static double variance (double v, double d)
{
    if (v > d) return (v - d);
    return (d - v);
}

int main(void)
{
    BEGIN_TESTS;
    TESTCASE( variance( _PDCLIB_clampradd(PI-MARGIN) , PI-MARGIN) < MARGIN );
    TESTCASE( variance( _PDCLIB_clampradd(-PI+MARGIN) , -PI+MARGIN) < MARGIN );
    TESTCASE( variance( _PDCLIB_clampradd(2*PI) , 0) < MARGIN );
    TESTCASE( variance( _PDCLIB_clampradd((-2)*PI) , 0 ) < MARGIN);
    return(TEST_RESULTS);
}

#endif
