/*
    Summary: abs.c
    *The libc implementation*

    Author:
        Martin 'Solar' Baute

    License:
        Public Domain
*/

/* abs( int )

   This file is part of the Public Domain C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdlib.h>

#ifndef REGTEST

/* Function: abs
   Returns the absolute value of a given integer */

int abs( int j )
{
    return ( j >= 0 ) ? j : -j;
}

#endif

#ifdef TEST
#include <_PDCLIB_test.h>
#include <limits.h>

int main()
{
    BEGIN_TESTS;
    TESTCASE( abs( 0 ) == 0 );
    TESTCASE( abs( INT_MAX ) == INT_MAX );
    TESTCASE( abs( INT_MIN + 1 ) == -( INT_MIN + 1 ) );
    return TEST_RESULTS;
}

#endif
