/*
    Summary: free.c
    *The libc implementation*

    Author:
        Martin 'Solar' Baute

    License:
        Public Domain
*/

/* void free( void * )

   This file is part of the Public Domain C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdlib.h>

#ifndef REGTEST

#ifndef _PDCLIB_INT_H
#define _PDCLIB_INT_H _PDCLIB_INT_H
#include <_PDCLIB_int.h>
#endif

/* TODO: Primitive placeholder. Much room for improvement. */

/* structure holding first and last element of free node list */
extern struct _PDCLIB_headnode_t _PDCLIB_memlist;

/*   Function: free
     Deallocates a block of memory created by <malloc> <calloc> or <realloc>.
     ptr references the allocated block */

void free( void * ptr )
{
    ptr = (void *)( (char *)ptr - sizeof( struct _PDCLIB_memnode_t ) );
    ( (struct _PDCLIB_memnode_t *)ptr )->next = NULL;
    if ( _PDCLIB_memlist.last != NULL )
    {
        _PDCLIB_memlist.last->next = (struct _PDCLIB_memnode_t *) ptr;
    }
    else
    {
        _PDCLIB_memlist.first = (struct _PDCLIB_memnode_t *) ptr;
    }
    _PDCLIB_memlist.last = (struct _PDCLIB_memnode_t *) ptr;
}

#endif

#ifdef TEST
#include <_PDCLIB_test.h>

int main()
{
    BEGIN_TESTS;
    /* tests covered in malloc test driver */
    return TEST_RESULTS;
}

#endif
