/*
    Summary: llabs.c
    *The libc implementation*

    Author:
        Martin 'Solar' Baute

    License:
        Public Domain
*/

/* llabs( long int )

   This file is part of the Public Domain C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdlib.h>

#ifndef REGTEST

/* Function: llabs
   Returns the absolute value of a given long long */

long long int llabs( long long int j )
{
    return ( j >= 0 ) ? j : -j;
}

#endif

#ifdef TEST
#include <_PDCLIB_test.h>
#include <limits.h>

int main()
{
    BEGIN_TESTS;
    TESTCASE( llabs( 0 ) == 0 );
    TESTCASE( llabs( LLONG_MAX ) == LLONG_MAX );
    TESTCASE( llabs( LLONG_MIN + 1 ) == -( LLONG_MIN + 1 ) );
    return TEST_RESULTS;
}

#endif
