/*
    Summary: srand.c
    *The libc implementation*

    Author:
        Martin 'Solar' Baute

    License:
        Public Domain
*/

/* srand( unsigned int )

   This file is part of the Public Domain C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdlib.h>

#ifndef REGTEST

/* Function: srand
   Sets the new seed to be used by <rand> */

void srand( unsigned int seed )
{
    _PDCLIB_seed = seed;
}

#endif

#ifdef TEST
#include <_PDCLIB_test.h>

int main()
{
    BEGIN_TESTS;
    /* tested in rand.c */
    return TEST_RESULTS;
}

#endif
