'
' Summary: hashmap.bas
' *Implements the hashmap datatype*
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "adt.bi"
   
Constructor MCHashMap
    Resize(7)
End Constructor

Destructor MCHashMap()
    Dim lp As Integer
    For lp = 0 to mMaplen - 1
        Dim list As MCLinkedListItem Ptr
        list = mHashmap[lp]
        list->Release
        mHashmap[lp] = CPtr(MCLinkedListItem Ptr, 0)	
    Next lp

    Deallocate mHashmap
End Destructor

Sub MCHashMap.Resize(ByVal size As Integer)
    Dim oldptr As MCLinkedListItem Ptr Ptr
    Dim oldsize As Integer
    oldptr = mHashmap
    oldsize = mMaplen    

    mHashmap = Allocate(size * Len(MCLinkedListItem Ptr))
    mMaplen = size
    mCountlen = 0

    ' reassign contents of the old map if necessary
    If oldptr <> CPtr(MCLinkedListItem Ptr Ptr, 0) Then
        Dim lp As Integer
        For lp = 0 to oldsize - 1
            Dim nodeptr As MCLinkedListItem Ptr
            nodeptr = oldptr[lp] 
            While nodeptr <> CPtr(MCLinkedListItem Ptr, 0) 
                ' transfer ownership of contents and next pointers
                Dim nodecontents As MCKeyValuePair Ptr
                nodecontents = CPtr(MCKeyValuePair Ptr, nodeptr->mContents)
                Dim tempnext As MCLinkedListItem Ptr                
                tempnext = nodeptr->mNextItem
                nodeptr->mNextItem = CPtr(MCLinkedListItem Ptr, 0)
                nodeptr->mContents = CPtr(MCObject Ptr, 0)

                ' release the linked list node
                nodeptr->Release
                nodeptr = tempnext

                ' reinsert existing node
                InsertPair nodecontents
                nodecontents->Release
            Wend
        Next lp

        ' free old list
        Deallocate oldptr
    End If
End Sub

Sub MCHashMap.Insert(ByVal key as MCHashable Ptr, ByVal value as MCObject Ptr)
    Dim pair As MCKeyValuePair Ptr
    pair = new MCKeyValuePair(key, value)
    InsertPair pair
    pair->Release
End Sub

Sub MCHashMap.InsertPair(ByVal pair As MCKeyValuePair Ptr)
    ' only allow increases in size (to avoid infinite loops on a resize)
    If (3 * mMaplen < 2 * mCountlen) Then
        Resize (2 * mMaplen + 1)
    End if
    
    ' get hash and chain index
    Dim sourcehash as Integer
    sourcehash = pair->mKey->mHashCode(pair->mKey)
    Dim index As Integer
    index = sourcehash Mod mMaplen
    If index < 0 Then index = index + mMaplen
    Dim chain As MCLinkedListItem Ptr
    chain = mHashmap[index]

    While chain <> Cptr(MCLinkedListItem Ptr, 0)
        Dim existing as MCKeyValuePair Ptr
        existing = CPtr(MCKeyValuePair Ptr, chain->mContents)
        If existing->mKey->mEquals(existing->mKey, pair->mKey) Then
            ' overwrite case
            existing->Release
            chain->mContents = pair
            pair->Retain
            Exit Sub
        End If
        chain = chain->mNextItem
    Wend
    
    ' insert case
    chain = new MCLinkedListItem(pair)
    chain->mNextItem = mHashmap[index]
    mHashmap[index] = chain 
    mCountlen = mCountlen + 1
End Sub

Function MCHashMap.Find(ByVal key As MCHashable Ptr) As MCObject Ptr
    Dim pair As MCKeyValuePair Ptr
    pair = FindPair(key)
    If pair = CPtr(MCKeyValuePair Ptr, 0) Then
        Function = CPtr(MCObject Ptr, 0)
    Else
        Function = pair->mValue
    End If
End Function

Function MCHashMap.FindPair(ByVal key As MCHashable Ptr) As MCKeyValuePair Ptr
    Dim hash As Integer
    hash = key->mHashCode(key) Mod mMaplen
    If hash < 0 Then hash = hash + mMaplen
    
    Dim chain As MCLinkedListItem Ptr
    chain = mHashmap[hash]
    While chain <> Cptr(MCLinkedListItem Ptr, 0)
        Dim pair As MCKeyValuePair Ptr
        pair = CPtr(MCKeyValuePair Ptr, chain->mContents)
        If pair->mKey->mEquals(pair->mKey, key) Then
            Function = pair
            Exit Function
        End If
        chain = chain->mNextItem
    Wend

    Function = CPtr(MCKeyValuePair Ptr, 0)
End Function

Function MCHashMap.Exists(ByVal key as MCHashable Ptr) As Integer
    Dim pair As MCKeyValuePair Ptr
    pair = FindPair(key)
    If pair = CPtr(MCKeyValuePair Ptr, 0) Then
        Function = 0
    Else
        Function = -1
    End If
End Function

Sub MCHashMap.Remove(ByVal key As MCHashable Ptr)
    Dim hash As Integer
    hash = key->mHashCode(key) Mod mMaplen
    If hash < 0 Then hash = hash + mMaplen

    Dim chain As MCLinkedListItem Ptr, preceding As MCLinkedListItem Ptr
    chain = mHashmap[hash]
    preceding = CPtr(MCLinkedListItem Ptr, 0)
    While chain <> CPtr(MCLinkedListItem Ptr, 0)
        Dim pair As MCKeyValuePair Ptr
        pair = CPtr(MCKeyValuePair Ptr, chain->mContents)
        If pair->mKey->mEquals(pair->mKey, key) Then
            If preceding <> CPtr(MCLinkedListItem Ptr, 0) Then
                preceding->mNextItem = chain->mNextItem
            Else
                mHashmap[hash] = chain->mNextItem
            End if
            chain->mNextItem = CPtr(MCLinkedListItem Ptr, 0)
            chain->Release

            ' keys are unique
            Exit Sub
        End If
        preceding = chain
        chain = chain->mNextItem
    Wend
End Sub

