'
' Summary: linkedlist.bas
' *Implements the linked list datastructure*
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "adt.bi"

Constructor MCLinkedList()
    mFirstItem = CPtr(MCLinkedListItem Ptr, 0)
    mLastItem = mFirstItem
End Constructor

Destructor MCLinkedList()
    Do While (mCount > 0)
        RemoveFront()
    Loop
End Destructor


Sub MCLinkedList.PushFront(ByVal item as MCObject Ptr)
    Dim linkitem As MCLinkedListItem Ptr
    linkitem = New MCLinkedListItem(item)
    linkitem->mNextItem = mFirstItem
    mFirstItem = linkitem
    mCount = mCount + 1
    If mLastItem = CPtr(MCLinkedListItem Ptr, 0) Then
        mLastItem = mFirstItem
    End If
End Sub

Sub MCLinkedList.PushBack(ByVal item as MCObject Ptr)
    Dim linkitem As MCLinkedListItem Ptr
    linkitem = New MCLinkedListItem(item)
    linkitem->mNextItem = CPtr(MCLinkedListItem Ptr, 0)
    If mFirstItem = CPtr(MCLinkedListItem Ptr, 0) Then
        mFirstItem = linkitem
        mLastItem = linkitem
    Else
        mLastItem->mNextItem = linkitem
        mLastItem = linkitem
    End If
    mCount = mCount + 1
End Sub

Function MCLinkedList.PeekFront() as MCObject Ptr
    Dim item as MCObject Ptr
    item = mFirstItem->mContents
    Function = item
    
    If item <> CPtr(MCLinkedListItem Ptr, 0) Then
        item->Retain
        item->Autorelease
    End If
End Function

Function MCLinkedList.PeekBack() as MCObject Ptr
    Dim item as MCObject Ptr
    item = mLastItem->mContents
    Function = item
    
    If item <> CPtr(MCLinkedListItem Ptr, 0) Then
        item->Retain
        item->Autorelease
    End If
End Function

Function MCLinkedList.GetAtIndex(ByVal index as Integer) as MCObject Ptr
    If index >= mCount or index < 0 Then
        Function = CPtr(MCObject Ptr, 0)
        Exit Function
    End If
    
    Dim iterator as MCLinkedListItem Ptr
    iterator = mFirstItem
    
    Dim indexcopy As Integer
    indexcopy = index
    While (indexcopy > 0)
        iterator = iterator->mNextItem
        indexcopy = indexcopy - 1
    Wend
    Function = iterator->mContents
    iterator->mContents->Retain
    iterator->mContents->Autorelease
End Function

Function MCLinkedList.PopFront() as MCObject Ptr
    If mFirstItem = CPtr(MCLinkedListItem Ptr, 0) Then
        Function = CPtr(MCObject Ptr, 0)
        Exit Function
    End If
    
    Dim listentry as MCLinkedListItem Ptr
    listentry = mFirstItem
    mFirstItem = listentry->mNextItem
    mCount = mCount - 1
    If mLastItem = listentry Then
        ' emptied list
        mLastItem = mFirstItem
    End If
    
    Dim item as MCObject Ptr
    item = listentry->mContents
    item->Retain
    item->Autorelease
    Function = item
    
    listentry->Release
End Function

Function MCLinkedList.PopBack() as MCObject Ptr
    If mFirstItem = CPtr(MCLinkedListItem Ptr, 0) Then
        Function = CPtr(MCObject Ptr, 0)
        Exit Function
    End If
    
    Dim listentry as MCLinkedListItem Ptr
    listentry = mLastItem
    If mFirstItem = mLastItem Then        
        mFirstItem = CPtr(MCLinkedListItem Ptr, 0)
        mLastItem = mFirstItem
    Else
        Dim loopentry As MCLinkedListItem Ptr
        loopentry = mFirstItem
        While loopentry->mNextItem <> listentry
            loopentry = loopentry->mNextItem            
        Wend
        mLastItem = loopentry
        loopentry->mNextItem = CPtr(MCLinkedListItem Ptr, 0)        
    End If
    
    mCount = mCount - 1
    Dim item as MCObject Ptr
    item = listentry->mContents
    item->Retain
    item->Autorelease
    Function = item
    
    listentry->Release
End Function


Sub MCLinkedList.RemoveFront()
    If mFirstItem = CPtr(MCLinkedListItem Ptr, 0) Then Exit Sub
    
    Dim listentry as MCLinkedListItem Ptr
    listentry = mFirstItem
    mFirstItem = mFirstItem->mNextItem
    If mLastItem = listentry Then
        mLastItem = mFirstItem
    End If
    mCount = mCount - 1
    listentry->Release
End Sub

Sub MCLinkedList.RemoveBack()
    If mLastItem = CPtr(MCLinkedListItem Ptr, 0) Then Exit Sub
    mCount = mCount - 1
    If mLastItem = mFirstItem Then
        mFirstItem->Release
        mFirstItem = CPtr(MCLinkedListItem Ptr, 0)
        mLastItem = mFirstItem
    Else
        Dim loopentry As MCLinkedListItem Ptr
        loopentry = mFirstItem
        While loopentry->mNextItem <> mLastItem
            loopentry = loopentry->mNextItem            
        Wend
        mLastItem->Release
        mLastItem = loopentry
    End If    
End Sub

'Sub MCLinkedList.RemoveAtIndex(ByVal index as Integer)
'
'End Sub

'Sub MCLinkedList.InsertAtIndex(ByVal item as MCObject Ptr, ByVal index as Integer)
'
'End Sub

