'
' Summary: mcobject.bas
' *Implements the base type dealing with reference counted memory management*
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "adt.bi"

Dim Shared Basepool As MCObject Ptr

Destructor MCObject
End Destructor

Constructor MCObject
    mRefcount = 1
    mAutocount = 0
    mAutoNext = CPtr(MCObject Ptr, 0)
End Constructor

Sub MCObject.Retain
    mRefcount = mRefcount + 1
End Sub

Sub MCObject.Release
    mRefcount = mRefcount - 1
    If mRefcount = 0 Then 
    	Delete @this
    End if
End Sub

Sub MCObject.Autorelease
    mAutocount = mAutocount + 1
    If (mAutocount = 1) Then
        mAutoNext = Basepool
	Basepool = @this
    End If
End Sub


