/* read stmt for long integer's */

#include "fb.h"

/*:::::*/
FBCALL void fb_DataReadLongint( long long *dst )
{
	short len;

	FB_LOCK();

	len = fb_DataGetLen();

	if( len == 0 )
		*dst = 0;
	else if( len == FB_DATATYPE_OFS )
		*dst = (long long)(unsigned long)__fb_data_ptr->ofs;
	/* wstring? */
	else if( len & FB_DATATYPE_WSTR )
        *dst = (long long)fb_WstrToLongint( __fb_data_ptr->wstr, len & 0x7FFF );
	else
        *dst = (long long)fb_hStr2Longint( __fb_data_ptr->zstr, len );

	if( __fb_data_ptr != NULL )
		++__fb_data_ptr;

	FB_UNLOCK();
}

