/* Array bound checking functions */

#include "fb.h"

/*:::::*/
static FB_ERRHANDLER hThrowError
	( 
		int linenum, 
		const char *fname 
	)
{
	/* call user handler if any defined */
    return fb_ErrorThrowEx( FB_RTERROR_OUTOFBOUNDS, linenum, fname, NULL, NULL );
}

/*:::::*/
FBCALL FB_ERRHANDLER fb_ArrayBoundChk
	( 
		int idx, 
		int lbound, 
		int ubound,
		int linenum, 
		const char *fname 
	)
{
	if( (idx < lbound) || (idx > ubound) )
		return hThrowError( linenum, fname );
	else
		return NULL;
}

/*:::::*/
FBCALL FB_ERRHANDLER fb_ArraySngBoundChk
	( 
		unsigned int idx, 
		unsigned int ubound,
		int linenum, 
		const char *fname 
	)
{
	if( idx > ubound )
		return hThrowError( linenum, fname );
	else
		return NULL;
}
