#include "../fb.h"
#include "x86.h"

extern char ** _MOS_cmdline;

// force runtime initialization into .ctors section
void (*call)(void) __attribute__ ((section (".ctors"))) = &fb_hInit;

void fb_hInit( void )
{

    char * const * items = _MOS_cmdline;
    int argc = 0;
    while (*items) { items++; argc++; }

    fb_Init(argc, _MOS_cmdline, 0);

    return;
}


void fb_hEnd( int unused )
{
    if (unused) {}
}

FBCALL NORETURN void fb_End( int errlevel )
{
    if (errlevel) 
    {
        const char * message = __fb_ctx.errmsg;
        while (message && *message)
	{
            outportb(0xE9, *message++);
	}
    }
    while(1)
    {
    }
}

