/*
    Summary: copyframebuffer.c
    contains the copy operator for a FramebufferData type

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#define UDI_GFX_VERSION 0x101
#include <libgfx/ast.h>
#include <stdlib.h>
#include <string.h>

void * LibGFX_CopyFramebufferData(void * in)
{
    if (!in) return NULL;
    void * temp = malloc(sizeof(AST_FramebufferData));
    if (!temp) return NULL;
    memcpy(temp, in, sizeof(AST_FramebufferData));
    return temp;
}

#ifdef TEST
#include <libgfx/test.h>

int main(void)
{
    BEGIN_TESTS;

    TESTCASE( LibGFX_CopyFramebufferData(NULL) == NULL);

    AST_FramebufferData temp;
    memset(&temp, sizeof(AST_FramebufferData), 6);

    void * copy = LibGFX_CopyFramebufferData(&temp);
    TESTCASE( copy != NULL );
    TESTCASE( memcmp(copy, &temp, sizeof(AST_FramebufferData)) == 0 );

    return(TEST_RESULTS);
}

#endif
