/*
    Summary: copylinearoffset.c
    contains the copy operator for a LinearOffsetData type

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#define UDI_GFX_VERSION 0x101
#include <libgfx/ast.h>
#include <stdlib.h>
#include <string.h>

void * LibGFX_CopyLinearOffsetData(void * in)
{
    if (!in) return NULL;
    void * temp = malloc(sizeof(AST_LinearOffsetData));
    if (!temp) return NULL;
    memcpy(temp, in, sizeof(AST_LinearOffsetData));
    return temp;
}

#ifdef TEST
#include <libgfx/test.h>

int main(void)
{
    BEGIN_TESTS;

    TESTCASE( LibGFX_CopyLinearOffsetData(NULL) == NULL);

    AST_LinearOffsetData temp;
    memset(&temp, sizeof(AST_LinearOffsetData), 6);

    void * copy = LibGFX_CopyLinearOffsetData(&temp);
    TESTCASE( copy != NULL );
    TESTCASE( memcmp(copy, &temp, sizeof(AST_LinearOffsetData)) == 0 );

    return(TEST_RESULTS);
}

#endif
