/*
    Summary: deletemap.c
    Delete an opcode map

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <libgfx/ast.h>
#include <stdlib.h>

void LibGFX_DeleteMap(AST_RawOpcodeMap * map)
{
    if (!map) return;
    if (map->data) free(map->data);
    free(map);
}

#ifdef TEST
#include <libgfx/test.h>

static int freecount = 0;
// trap calls to free()
void free(void * ptr)
{
    freecount++;
}

int main(void)
{
    BEGIN_TESTS;
    freecount = 0;
    AST_RawOpcodeMap m;
    m.data = NULL;

    LibGFX_DeleteMap(NULL);
    TESTCASE( freecount == 0 );

    LibGFX_DeleteMap(&m);
    TESTCASE( freecount == 1 );

    int temp;
    m.data = &temp;
    LibGFX_DeleteMap(&m);
    TESTCASE( freecount == 3 );

    return(TEST_RESULTS);
}

#endif
