/*
    Summary: freebit.c
    Bitlist cleanup functions

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <libgfx/ast.h>
#include <stdlib.h>

void LibGFX_FreeBitlist (AST_Bit * root)
{
    while (root)
    {
        AST_Bit * next = root->next_bit;
        if (root->source_node) LibGFX_FreeNode(root->source_node);
        free(root);
        root = next;
    }
}

#ifdef TEST
#include <libgfx/test.h>

int main(void)
{
    BEGIN_TESTS;
 
    TESTCASE( NO_TESTDRIVER );

    return(TEST_RESULTS);
}


#endif
