/*
    Summary: freenode.c
    Node cleanup functions

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#include <libgfx/ast.h>
#include <stdlib.h>

void LibGFX_FreeNode (AST_Node * node)
{
    if (!node) return;
    
    node->refcount--;
    if (node->refcount == 0)
    {
        for (int i = 0; i < node->childcount; i++)
        {
            LibGFX_FreeNode(node->children[i]);
        }
        if (node->children) free(node->children);
        if (node->data) node->freedata(node->data);
        free(node);
    }
}

#ifdef TEST
#include <libgfx/test.h>

static int freecount = 0;

void freefunc(void * v)
{
    freecount++;
}

int main(void)
{
    BEGIN_TESTS;

    AST_Node * n1 = (AST_Node*) malloc(sizeof(AST_Node));
    AST_Node * n2 = (AST_Node*) malloc(sizeof(AST_Node));
    n2->childcount = 2;
    n2->refcount = 2;
    n2->children = (AST_Node **) malloc(2 * sizeof(AST_Node *));
    n2->children[0] = n1;
    n2->children[1] = n1;
    n2->data = (void*)n2;
    n2->freedata = &freefunc;

    n1->refcount = 4;
    n1->childcount = 0;
    n1->children = NULL;
    n1->freedata = &freefunc;
    n1->data = (void*)n1;

    AST_Node * n3 = (AST_Node*) malloc(sizeof(AST_Node));
    n3->childcount = 1;
    n3->refcount = 1;
    n3->children = (AST_Node **) malloc(1 * sizeof(AST_Node *));
    n3->children[0] = n1;
    n3->data = NULL;
    n3->freedata = NULL;

    LibGFX_FreeNode(NULL);
    TESTCASE( n1->refcount == 4 );
    TESTCASE( n2->refcount == 2 );
    TESTCASE( n3->refcount == 1 );
    TESTCASE( freecount == 0 );

    LibGFX_FreeNode(n1);
    TESTCASE( n1->refcount == 3 );
    TESTCASE( n2->refcount == 2 );
    TESTCASE( n3->refcount == 1 );
    TESTCASE( freecount == 0 );

    LibGFX_FreeNode(n2);
    TESTCASE( n1->refcount == 3 );
    TESTCASE( n2->refcount == 1 );
    TESTCASE( n3->refcount == 1 );
    TESTCASE( freecount == 0 );

    LibGFX_FreeNode(n2);
    TESTCASE( n1->refcount == 1 );
    TESTCASE( n3->refcount == 1 );
    TESTCASE( freecount == 1 );

    LibGFX_FreeNode(n3);
    TESTCASE( freecount == 2 );

    return(TEST_RESULTS);
}

#endif
