/*
    Summary: substfb.c
    Folds buffer trees into a framebuffer node

    Author:
        Marcel Sondaar

    License:
        Public Domain

 */

#define UDI_GFX_VERSION 0x101
#define UDI_VERSION 0x101
#include <udi_gfx.h>
#include <libgfx/ast.h>
#include <libgfx/error.h>
#include <stdlib.h>

int LibGFX_TreeSubstFramebuffer (AST_Node * root)
{
    if (!root) return 0;

    switch (root->opcode)
    {
        case UDI_GFX_OPERATOR_BUFFER:
        {
            if (root->children[1] == NULL) return 0;
            if (root->children[0] == NULL) return 0;
            if (root->children[1]->opcode != AST_OPCODE_ADDRGEN) return 0;
            int which, cv, av;
            which = LibGFX_ConstAttrFold(root->children[0], &cv, &av);
            if ((which != 1) && (which != 2)) return 0;

            AST_FramebufferData * newdata = (AST_FramebufferData*)malloc(sizeof(AST_FramebufferData));
            if (!newdata)
            {
                libgfx_errormsg = "SubstFramebuffer: out of memory";
                return 0;
            }

            root->opcode = AST_OPCODE_FRAMEBUFFER;
            root->data = (void*) newdata;
            newdata->offset = *((AST_LinearOffsetData*)root->children[1]->data);
            newdata->bufferbits = root->const1;
            newdata->bufferindexattr = (which == 2) ? av : -1;
            newdata->bufferindexconst = (which == 1) ? cv : -1;
            LibGFX_FreeNode(root->children[1]);
            LibGFX_FreeNode(root->children[0]);
            root->childcount = 0;
            free(root->children);
            root->children = NULL;
            root->freedata = &free;
            root->clonedata = &LibGFX_CopyFramebufferData;

            return 1;
        }

        default:
        {
            int count = 0;
            for (int i = 0; i < root->childcount; i++)
                count += LibGFX_TreeSubstFramebuffer(root->children[i]);
            return count;
        }
    }
}

#ifdef TEST
#include <libgfx/test.h>

int main(void)
{
    BEGIN_TESTS;

    TESTCASE( NO_TESTDRIVER );

    return(TEST_RESULTS);
}

#endif
