/* Summary: glclearcolor.c
 * Implements the glClearColor function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <swgl/glbuffer.h>

GLubyte _gl_clear_r = 0;
GLubyte _gl_clear_g = 0;
GLubyte _gl_clear_b = 0;
GLubyte _gl_clear_a = 0;

void glClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
    _gl_clear_r = (int)(red * 255.0f + 0.5f);
    _gl_clear_g = (int)(green * 255.0f + 0.5f);
    _gl_clear_b = (int)(blue * 255.0f + 0.5f);
    _gl_clear_a = (int)(alpha * 255.0f + 0.5f);

    if (red < 0)   _gl_clear_r = 0;
    if (green < 0) _gl_clear_g = 0;
    if (blue < 0)  _gl_clear_b = 0;
    if (alpha < 0) _gl_clear_a = 0;
    if (red > 1)   _gl_clear_r = 255;
    if (green > 1) _gl_clear_g = 255;
    if (blue > 1)  _gl_clear_b = 255;
    if (alpha > 1) _gl_clear_a = 255;
}
