/* Summary: glcolorf.c
 * Implements the glColor function for floats
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <swgl/glpipe.h>

GLubyte _gl_vc_r = 255;
GLubyte _gl_vc_g = 255;
GLubyte _gl_vc_b = 255;
GLubyte _gl_vc_a = 255;

void glColor4f(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
    _gl_vc_r = (int)(red * 255.0f + 0.5f);
    _gl_vc_g = (int)(green * 255.0f + 0.5f);
    _gl_vc_b = (int)(blue * 255.0f + 0.5f);
    _gl_vc_a = (int)(alpha * 255.0f + 0.5f);

    if (red < 0)   _gl_vc_r = 0;
    if (green < 0) _gl_vc_g = 0;
    if (blue < 0)  _gl_vc_b = 0;
    if (alpha < 0) _gl_vc_a = 0;
    if (red > 1)   _gl_vc_r = 255;
    if (green > 1) _gl_vc_g = 255;
    if (blue > 1)  _gl_vc_b = 255;
    if (alpha > 1) _gl_vc_a = 255;
    
    _gl_rendertri = _gl_rendertricol;
}

void glColor3f(GLclampf red, GLclampf green, GLclampf blue)
{
    _gl_vc_r = (int)(red * 255.0f + 0.5f);
    _gl_vc_g = (int)(green * 255.0f + 0.5f);
    _gl_vc_b = (int)(blue * 255.0f + 0.5f);

    if (red < 0)   _gl_vc_r = 0;
    if (green < 0) _gl_vc_g = 0;
    if (blue < 0)  _gl_vc_b = 0;
    if (red > 1)   _gl_vc_r = 255;
    if (green > 1) _gl_vc_g = 255;
    if (blue > 1)  _gl_vc_b = 255;
    
    _gl_vc_a = 255;
    
    _gl_rendertri = _gl_rendertricol;
}
