/* Summary: gldisable.c
 * Implements the glDisable function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <swgl/glpipe.h>
#include <swgl/glbuffer.h>

void glDisable(GLenum cap)
{
    switch(cap)
    {
        case GL_CULL_FACE:
            _gl_cull_enable = 0;
            break;

        case GL_SCISSOR_TEST:
            _gl_scissor_en = 0;
            _gl_cutoff_n = 0;
            _gl_cutoff_e = _gl_backbuffer->width;
            _gl_cutoff_s = _gl_backbuffer->height;
            _gl_cutoff_w = 0;
            break;

        case GL_TEXTURE_2D:
            _gl_rendertriflat = _gl_flattriangle32;
            _gl_rendertricol = _gl_goraudtriangle32;

        default:
            break;
    }
}
