/* Summary: glenable.c
 * Implements the glEnable function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>

#include <swgl/glpipe.h>
#include <swgl/glbuffer.h>

void glEnable(GLenum cap)
{
    switch(cap)
    {
        case GL_CULL_FACE:
            _gl_cull_enable = 1;
            break;

        case GL_SCISSOR_TEST:
            _gl_scissor_en = 1;
            _gl_cutoff_n = _gl_scissor_n;
            _gl_cutoff_e = _gl_scissor_e;
            _gl_cutoff_s = _gl_scissor_s;
            _gl_cutoff_w = _gl_scissor_w;
            break;

        case GL_TEXTURE_2D:
            _gl_rendertriflat = _gl_textriangle32;
            _gl_rendertricol = _gl_textriangle32;
            break;


        
        default:
            break;
    }
}
