/* Summary: glmaxtrixmode.c
 * Implements the glMatrixMode function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <swgl/glmatrix.h>

void glFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
    _gl_matrixvalid = 0;

    // x column
    _gl_selectedmatrix->m[ 0] = zNear * 2.0f / (right - left);
    _gl_selectedmatrix->m[ 4] = 0;
    _gl_selectedmatrix->m[ 8] = (right+left)/(right-left);
    _gl_selectedmatrix->m[12] = 0;

    // y column
    _gl_selectedmatrix->m[ 1] = 0;
    _gl_selectedmatrix->m[ 5] = zNear * 2.0f / (top - bottom);
    _gl_selectedmatrix->m[ 9] = (top+bottom) / (top-bottom);
    _gl_selectedmatrix->m[13] = 0;

    // z column
    _gl_selectedmatrix->m[ 2] = 0;
    _gl_selectedmatrix->m[ 6] = 0;
    _gl_selectedmatrix->m[10] = -1.0f * (zFar + zNear) / (zFar-zNear);
    _gl_selectedmatrix->m[14] = -2.0f * zFar * zNear / (zFar-zNear);

    // w column
    _gl_selectedmatrix->m[ 3] = 0;
    _gl_selectedmatrix->m[ 7] = 0;
    _gl_selectedmatrix->m[11] = -1;
    _gl_selectedmatrix->m[15] = 0;

}
