/* Summary: glmaxtrixmode.c
 * Implements the glMatrixMode function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <swgl/glmatrix.h>

GLint _gl_selectedstack = GL_MODELVIEW;

void glMatrixMode(GLenum mode)
{
    switch(_gl_selectedstack)
    {
        case GL_MODELVIEW:
            _gl_modelview_top = _gl_selectedstack_top;
            break;

        case GL_PROJECTION:
            _gl_projection_top = _gl_selectedstack_top;
            break;

        case GL_TEXTURE:
            _gl_texture_top = _gl_selectedstack_top;
            break;

        default:
            /* todo: invalid argument */
            return;
    }
    
    switch(mode)
    {
        case GL_MODELVIEW:
            _gl_selectedmatrix = &(_gl_modelview_stack[_gl_modelview_top]);
            _gl_selectedstack_top = _gl_modelview_top;
            break;

        case GL_PROJECTION:
            _gl_selectedmatrix = &(_gl_projection_stack[_gl_projection_top]);
            _gl_selectedstack_top = _gl_projection_top;
            break;

        case GL_TEXTURE:
            _gl_selectedmatrix = &(_gl_texture_stack[_gl_texture_top]);
            _gl_selectedstack_top = _gl_texture_top;
            break;

        default:
            /* todo: invalid argument */
            return;
    }

}
