/* Summary: glrotatef.c
 * implements the glRotatef function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <math.h>
#include <swgl/glmatrix.h>

void glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    GLfloat nx, ny, nz, size, s, c;
    size = x * x + y * y + z * z;
    if (size - 1.0f < 0 || size - 1.0f > 0)
    {
        size = 1 / sqrtf(size);
        nx = x * size;
        ny = y * size;
        nz = z * size;
    }
    else
    {
        nx = x;
        ny = y;
        nz = z;
    }
    s = sinf(angle * 3.14159265 / 180.0f);
    c = cosf(angle * 3.14159265 / 180.0f);

    GLmatrix m;
    m.m[0] = nx*nx*(1-c)+c;     m.m[4] = ny*nx*(1-c)-nz*s;  m.m[8] = nz*nx*(1-c)+ny*s;  m.m[12] = 0;
    m.m[1] = nx*ny*(1-c)+nz*s;  m.m[5] = ny*ny*(1-c)+c;     m.m[9] = nz*ny*(1-c)-nx*s;  m.m[13] = 0;
    m.m[2] = nx*nz*(1-c)-ny*s;  m.m[6] = ny*nz*(1-c)+nx*s;  m.m[10]= nz*nz*(1-c)+c;     m.m[14] = 0;
    m.m[3] = 0;                 m.m[7] = 0;                 m.m[11]= 0;                 m.m[15] = 1;

    _gl_matrixmultiply(_gl_selectedmatrix, &m);
    _gl_matrixvalid = 0;

}
