/* Summary: glscissor.c
 * implements the glScissor function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <GL/gl.h>
#include <swgl/glbuffer.h>

GLint _gl_scissor_n, _gl_scissor_e, _gl_scissor_s, _gl_scissor_w;
GLint _gl_cutoff_n, _gl_cutoff_e, _gl_cutoff_s, _gl_cutoff_w;

GLubyte _gl_scissor_en = 0;

void glScissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    _gl_scissor_w = x;
    _gl_scissor_s = _gl_backbuffer->height - y;
    _gl_scissor_e = x + width;
    _gl_scissor_n = _gl_backbuffer->height - (y + height);

    if (_gl_scissor_n < 0) _gl_scissor_n = 0;
    if (_gl_scissor_w < 0) _gl_scissor_w = 0;
    if (_gl_scissor_e > _gl_backbuffer->width) _gl_scissor_e = _gl_backbuffer->width;
    if (_gl_scissor_s > _gl_backbuffer->height) _gl_scissor_s = _gl_backbuffer->height;

    if ((_gl_scissor_n >= _gl_scissor_s) || (_gl_scissor_w >= _gl_scissor_e))
    {
        _gl_scissor_s = _gl_scissor_n - 1;
        _gl_scissor_e = _gl_scissor_n - 1;
    }

    if(_gl_scissor_en) glEnable(GL_SCISSOR_TEST);

}
