/* Summary: gltexcoordf.c
 * Implements the glTexCoord function for floats
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <swgl/glpipe.h>

GLfloat _gl_vt_u = 0, _gl_vt_v = 0, _gl_vt_w = 0, _gl_vt_h = 1.0f;

void glTexCoord2f(GLfloat s, GLfloat t)
{
    _gl_vt_u = s;
    _gl_vt_v = t;
    _gl_vt_w = 0.0f;
    _gl_vt_h = 1.0f;
}

void glTexCoord3f(GLfloat s, GLfloat t, GLfloat u)
{
    _gl_vt_u = s;
    _gl_vt_v = t;
    _gl_vt_w = u;
    _gl_vt_h = 1.0f;
}

void glTexCoord4f(GLfloat s, GLfloat t, GLfloat u, GLfloat v)
{
    _gl_vt_u = s;
    _gl_vt_v = t;
    _gl_vt_w = u;
    _gl_vt_h = v;
}
