/* Summary: glteximage2d.c
 * Implements the glTexImage2D function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <stdlib.h>
#include <swgl/gltexture.h>

static GLubyte popdata(GLubyte ** readptr, GLenum type)
{
    GLubyte * ptr = *readptr;
    switch(type)
    {
        case GL_BYTE:
            readptr++;
            if (*((GLbyte *) ptr) < 0) return 0;
            return *((GLbyte *) ptr);

        case GL_UNSIGNED_BYTE:
            readptr++;
            return *ptr;

        case GL_UNSIGNED_SHORT:
            readptr += 2;
            if (*((GLushort *) ptr) > 255) return 255;
            return *((GLushort *) ptr);

        case GL_SHORT:
            readptr += 2;
            if (*((GLshort *) ptr) < 0)   return 0;
            if (*((GLshort *) ptr) > 255) return 255;
            return *((GLshort *) ptr);
            
        case GL_UNSIGNED_INT:
            readptr += 4;
            if (*((GLuint *) ptr) > 255) return 255;
            return *((GLuint *) ptr);

        case GL_INT:
            readptr += 4;
            if (*((GLint *) ptr) < 0)   return 0;
            if (*((GLint *) ptr) > 255) return 255;
            return *((GLint *) ptr);

        case GL_FLOAT:
            readptr += 4;
            break;

        default:
            break;
    }
    return 0;
}

void glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format,	GLenum type, const GLvoid *pixels )
{
    if (target != GL_TEXTURE_2D) return;
    if (level != 0) return;
    if (internalformat) {} // TODO: implement

    GLint usize = width;
    GLint vsize = height;
    GLint ubits = 0;
    GLint vbits = 0;
    while (usize > 1) { usize >>= 1; ubits++; }
    while (vsize > 1) { vsize >>= 1; vbits++; }
    usize = 1 << ubits;
    vsize = 1 << vbits;

    GLtexture * tex;
    tex = (GLtexture *) malloc(sizeof(GLtexture));
    tex->texture.base = (GLubyte *) malloc(sizeof(GLint) * usize * vsize);
    tex->ubits = ubits;
    tex->vbits = vbits;

    tex->texture.width = width;
    tex->texture.height = height;
    tex->texture.pitch = usize * 4;
    tex->texture.stride = 4;

    tex->border = border;
    
    _gl_deletetexture(_gl_currenttexture);
    _gl_currenttexture = tex;

    int x, y;

    GLubyte * inptr = (GLubyte *) pixels;
    GLubyte * outptr = tex->texture.base;

    // sort out common cases before doing the slow brute-force thing
    if (format == GL_RGB && type == GL_UNSIGNED_BYTE)
    {
        for (y = 0; y < height; y++)
        {
            for (x = 0; x < width; x++)
            {
                *outptr++ = *inptr++;
                *outptr++ = *inptr++;
                *outptr++ = *inptr++;
                *outptr++ = 0;
            }
        }
    }
    else if (format == GL_RGBA && type == GL_UNSIGNED_BYTE)
    {
        y = width * height * 4;
        for (x = 0; x < y; x++)
            *outptr++ = *inptr++;
    }
    else
    {
        for (y = 0; y < height; y++)
        for (x = 0; x < width; x++)
        {
            switch(format)
            {
                case GL_RED:
                    *outptr++ = popdata(&inptr, type);
                    *outptr++ = 0;
                    *outptr++ = 0;
                    *outptr++ = 0;
                    break;
                case GL_GREEN:
                    *outptr++ = 0;
                    *outptr++ = popdata(&inptr, type);
                    *outptr++ = 0;
                    *outptr++ = 0;
                    break;
                case GL_BLUE:
                    *outptr++ = 0;
                    *outptr++ = 0;
                    *outptr++ = popdata(&inptr, type);
                    *outptr++ = 0;
                    break;
                case GL_ALPHA:
                    *outptr++ = 0;
                    *outptr++ = 0;
                    *outptr++ = 0;
                    *outptr++ = popdata(&inptr, type);
                    break;

                case GL_RGB:
                    *outptr++ = popdata(&inptr, type);
                    *outptr++ = popdata(&inptr, type);
                    *outptr++ = popdata(&inptr, type);
                    *outptr++ = 0;
                    break;

                case GL_RGBA:
                    *outptr++ = popdata(&inptr, type);
                    *outptr++ = popdata(&inptr, type);
                    *outptr++ = popdata(&inptr, type);
                    *outptr++ = popdata(&inptr, type);
                    break;

                case GL_COLOR_INDEX:
                case GL_LUMINANCE:
                case GL_LUMINANCE_ALPHA:                
                    break;
                    
                default:
                    // TODO: error
                    break;
            }
        }
    }

    // byteswap
    GLubyte r, b;
    outptr = tex->texture.base;
    for (y = 0; y < vsize; y++)
    for (x = 0; x < usize; x++)
    {
        GLubyte * ptr = &outptr[4*x + 4*usize*y];
        r = ptr[0];
        b = ptr[2];
        ptr[0] = b;
        ptr[2] = r;
    }
}
