/* Summary: gltexsubimage2d.c
 * Sets a subsection of a bitmap to the specified pixel data
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <stdlib.h>
#include <swgl/gltexture.h>
#include <swgl/glbuffer.h>

void glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels )
{

    if (target != GL_TEXTURE_2D && target != GL_BUFFER_2D) return;
    if (level != 0) return;

    if (target == GL_TEXTURE_2D)
    {
        _gl_writebuffer_b8g8r8x8(xoffset, yoffset, width, height, format, type, pixels, &(_gl_currenttexture->texture));
    }
    else if (target == GL_BUFFER_2D)
    {
        _gl_currentbuffer->writebuffer(xoffset, yoffset, width, height, format, type, pixels, _gl_currentbuffer);
    }
    else return;

}
