/* Summary: gltranslatef.c
 * implements the glTranslatef function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <swgl/glmatrix.h>

void glTranslatef(GLfloat x, GLfloat y, GLfloat z)
{
    GLmatrix m;
    
    m.m[0] = 1;     m.m[4] = 0;     m.m[8] = 0;     m.m[12] = x;
    m.m[1] = 0;     m.m[5] = 1;     m.m[9] = 0;     m.m[13] = y;
    m.m[2] = 0;     m.m[6] = 0;     m.m[10]= 1;     m.m[14] = z;
    m.m[3] = 0;     m.m[7] = 0;     m.m[11]= 0;     m.m[15] = 1;

    _gl_matrixmultiply(_gl_selectedmatrix, &m);
    _gl_matrixvalid = 0;
}
