/* Summary: glvertex.c
 * Implements the glVertex base functionality
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <swgl/glpipe.h>
#include <swgl/glmatrix.h>

GLvertex _gl_pipe_vtx[4];

GLenum _gl_vertindex;

static void _gl_pushtriangle(GLvertex *, GLvertex*, GLvertex*);

void glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{

    float mx, my, mz, mw;
    mx = _gl_currentmatrix.m[ 0] * x
       + _gl_currentmatrix.m[ 4] * y
       + _gl_currentmatrix.m[ 8] * z
       + _gl_currentmatrix.m[12] * w;
    my = _gl_currentmatrix.m[ 1] * x
       + _gl_currentmatrix.m[ 5] * y
       + _gl_currentmatrix.m[ 9] * z
       + _gl_currentmatrix.m[13] * w;
    mz = _gl_currentmatrix.m[ 2] * x
       + _gl_currentmatrix.m[ 6] * y
       + _gl_currentmatrix.m[10] * z
       + _gl_currentmatrix.m[14] * w;
    mw = _gl_currentmatrix.m[ 3] * x
       + _gl_currentmatrix.m[ 7] * y
       + _gl_currentmatrix.m[11] * z
       + _gl_currentmatrix.m[15] * w;

    mw = 1.0f / mw;
    mx *= mw;
    my *= mw;
    mz *= mw;
    
    mx += _gl_viewoffx;
    my += _gl_viewoffy;

    _gl_pipe_vtx[_gl_vertindex].vx = mx;
    _gl_pipe_vtx[_gl_vertindex].vy = my;
    _gl_pipe_vtx[_gl_vertindex].vz = mz;
    _gl_pipe_vtx[_gl_vertindex].vw = mw;

    _gl_pipe_vtx[_gl_vertindex].cr = _gl_vc_r;
    _gl_pipe_vtx[_gl_vertindex].cg = _gl_vc_g;
    _gl_pipe_vtx[_gl_vertindex].cb = _gl_vc_b;
    _gl_pipe_vtx[_gl_vertindex].ca = _gl_vc_a;

    _gl_pipe_vtx[_gl_vertindex].tu = _gl_vt_u;
    _gl_pipe_vtx[_gl_vertindex].tv = _gl_vt_v;

    switch(_gl_rendermode)
    {
        case GL_TRIANGLES:

            _gl_vertindex++;
            if (_gl_vertindex == 3)
            {
                _gl_vertindex = 0;
                _gl_pushtriangle(&(_gl_pipe_vtx[0]), &(_gl_pipe_vtx[1]), &(_gl_pipe_vtx[2]));
            }
            break;

        default:
            break;
    }

}

static void _gl_pushtriangle(GLvertex * v1, GLvertex* v2, GLvertex* v3)
{
    if (_gl_cull_enable)
    {
        int dx1, dy1, dx2, dy2, crossprod;
        dx1 = v2->vx - v1->vx; dy1 = v2->vy - v1->vy;
        dx2 = v3->vx - v1->vx; dy2 = v3->vy - v1->vy;
        crossprod = dx1*dy2 - dx2*dy1;

        if (crossprod == 0) return; // zero-surface triangle
        if (_gl_cull_sign <= 0 && crossprod > 0) return;
        if (_gl_cull_sign >= 0 && crossprod < 0) return;
    }

    _gl_rendertri(v1, v2, v3);

}
