/* Summary: glviewport.c
 * implements the glViewport function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <GL/gl.h>
#include <swgl/glmatrix.h>
#include <swgl/glbuffer.h>

GLmatrix _gl_viewportmatrix;
GLint _gl_viewoffx;
GLint _gl_viewoffy;

void glViewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    int n;

    for (n = 0; n < 16; n++)
        _gl_viewportmatrix.m[n] = 0;

    _gl_viewportmatrix.m[0] = ((GLfloat)width) / 2.0f;
    _gl_viewportmatrix.m[5] = ((GLfloat)height) / -2.0f;
    _gl_viewportmatrix.m[10] = 1;
    _gl_viewportmatrix.m[15] = 1;
    _gl_viewoffx = width / 2 + x;
    _gl_viewoffy = _gl_backbuffer->height - height / 2 - y;

    _gl_matrixvalid = 0;
}
