/* Summary: glblitext.c
 * Implements the glBlitEXT extention function
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <swgl/gltexture.h>
#include <swgl/glpipe.h>

void glBlitEXT(GLint source, GLint dest, GLint srcx, GLint srcy, GLint dstx, GLint dsty, GLint width, GLint height)
{
    if (!_gl_currenttexture) return;
    if (height <= 0) return;

    // clamp to window
    if (dstx < _gl_scissor_w)
    {
        srcx = srcx + _gl_scissor_w - dstx;
        width = width - _gl_scissor_w + dstx;
        dstx = _gl_scissor_w;
    }
    if (width <= 0) return;
    if (dstx + width > _gl_scissor_e)
    {
        width = _gl_scissor_e - dstx;
    }
    if (width <= 0) return;

    if (dsty < _gl_scissor_s)
    {
        srcy = srcy + _gl_scissor_s - dsty;
        height = height - _gl_scissor_s + dsty;
        height = _gl_scissor_s;
    }
    if (height <= 0) return;
    if (dsty + height > _gl_scissor_n)
    {
        height = _gl_scissor_n - dsty;
    }
    if (height <= 0) return;

    if (srcx < 0) return;
    if (srcy < 0) return;
    if (srcx >= _gl_currenttexture->texture.width) return;
    if (srcy >= _gl_currenttexture->texture.height) return;

    if (srcx + width > _gl_currenttexture->texture.width)
        width = _gl_currenttexture->texture.width - srcx;
    if (width <= 0) return;

    if (srcy + height > _gl_currenttexture->texture.height)
        height = _gl_currenttexture->texture.height - srcy;
    if (height <= 0) return;

    _gl_renderblit(srcx, srcy, dstx, dsty, width, height);

}
