/* Summary: glxreceive.c
 * Retrieves data from a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <string.h>
#include <stdlib.h>
#include <GL/glx_opcodes.h>
#include <mos/drivercom.h>
#include <mos.h>
#include <swgl/glxclient.h>

/* Function: _glx_retrieve
 * enqueues a command for transmission to the server
 *
 * in:
 *     length - pointer to an integer to hold the length of the returned packet
 *
 * out:
 *     pointer to a buffer containing the data. This buffer should be released with free()
 */
GLubyte * _glx_retrieve(GLsizei * length)
{
    int msgsize = 0;
    while (!(msgsize = drv_peekmessage()))
    {
        yield();
    }
    GLubyte * data = (GLubyte *) malloc(msgsize);
    *length = msgsize - 4;

    drv_readmessage((char*)data);
    memmove(data, data+4, msgsize-4); // strip header
    data[msgsize-4] = 0;
    return data;
}
