/* Summary: glxschedule.c
 * Enqueues data in a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <string.h>
#include <GL/glx_opcodes.h>
#include <mos/drivercom.h>
#include <mos/gfx.h>

#include <swgl/glxclient.h>

/* Function: _glx_schedule
 * enqueues a command for transmission to the server
 *
 * in:
 *     data - pointer to the glx packet
 *     length - length of the glx packet
 *
 * out:
 *     none
 */
void _glx_schedule(void * data, int length)
{
    int buffer[128]; // 512 bytes
    buffer[0] = GFXCOMMAND_GLMESSAGE;
    memcpy(&(buffer[3]), data, length);
    buffer[2] = length;
    drv_sendmessage(_glx_messagedest, length + 12, (char *)buffer);
}
