/* Summary: mglgetconnector.c
 * Retrieving low level connector states
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <swgl/glxclient.h>
#include <GL/gl.h>
#include <mos/drivercom.h>
#include <mos.h>
#include <mos/gfx.h>

/* Function: mglGetConnectorState
 * Gets an graphics output connector state property
 *
 * in:
 *     index    - The connector to read
 *     property - The property of the connector to read. Often an element of <UDI_GFX_PROP>.
 *
 * out:
 *     return   - The current value of the property
 */
int mglGetConnectorState(int index, unsigned int property)
{
    int outbuffer[4] = {GFXCOMMAND_GETCONNECTOR, 0, index, property};
    drv_sendmessage(_glx_messagedest, 16, (char *)outbuffer);

    int rcvlen = 0;
    while ((rcvlen = drv_peekmessage()) == 0)
    {
        yield();
    }
    if (rcvlen != 20) *(char *)0x30008 = 0;
    
    int inbuffer[5];
    drv_readmessage((char*) inbuffer);
    return(inbuffer[4]);
}
