/* Summary: mglgetengine.c
 * Retrieving low level engine states
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <swgl/glxclient.h>
#include <GL/gl.h>
#include <mos/drivercom.h>
#include <mos.h>
#include <mos/gfx.h>

/* Function: mglGetEngineState
 * Gets an graphics engine state property
 *
 * in:
 *     index    - The engine to read
 *     property - The property of the engine to read. Often an element of <UDI_GFX_PROP>.
 *
 * out:
 *     return   - The current value of the property
 */
int mglGetEngineState(int index, unsigned int property)
{
    int outbuffer[4] = {GFXCOMMAND_GETENGINE, 1, index, property};
    drv_sendmessage(_glx_messagedest, 16, (char *)outbuffer);

    int rcvlen = 0;
    while ((rcvlen = drv_peekmessage()) == 0)
    {
        yield();
    }
    if (rcvlen != 20) *(char *)0x30005 = 0;
    
    int inbuffer[5];
    drv_readmessage((char*) inbuffer);
    return(inbuffer[4]);
}
