/* Summary: mglgetrange.c
 * Retrieving low level ranges
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <swgl/glxclient.h>
#include <GL/gl.h>
#include <mos/drivercom.h>
#include <mos.h>
#include <stdlib.h>
#include <mos/gfx.h>

static int * range = NULL;
static int rangelength = 0;
static int requestrange(int type, int index, unsigned int property);

int requestrange(int type, int index, unsigned int property)
{
    int outbuffer[5] = {GFXCOMMAND_RANGECONNECTOR + type, type, index, property, 0};
    drv_sendmessage(_glx_messagedest, 20, (char *)outbuffer);

    int rcvlen = 0;
    while ((rcvlen = drv_peekmessage()) == 0)
    {
        yield();
    }
    if (rcvlen < 32) *(char *)0x30007 = 0;
    if ((rcvlen - 20) % 12 != 0) *(char *)0x30008 = 0;
    
    int newrangelength = (rcvlen - 20) / 12;
    if (newrangelength > rangelength)
    {
        if (range) free(range);
        range = (int *) malloc(sizeof(int) * (3 * newrangelength + 4));
    }

    rangelength = newrangelength;

    drv_readmessage((char*) range);
    return rangelength;
}

/* Function: mglGetLastRangeEntry
 * Retrieves a range segment from an graphics component
 *
 * in:
 *     index    - The segment to read
 *
 * inout:
 *     first    - Pointer to an integer to hold the first valid value of the segment.
 *     last     - Pointer to an integer to hold the last valid value of the segment.
 *     modulus  - Pointer to an integer to hold the increment between successive values.
 *
 * Arguments may not be null. If the index is not valid, the result is undefined.
 * Drivers will indicate unsupported properties by returning a modulus of zero.
 */
void mglGetLastRangeEntry(int index, int * first, int * last, int * modulus)
{
    if (index < 0) return;
    if (index >= rangelength) return;
    *first = range[3 * index + 5];
    *last = range[3 * index + 6];
    *modulus = range[3 * index + 7];
}

/* Function: mglGetEngineRange
 * Gets the valid range of values from a engine property.
 *
 * in:
 *     index    - The engine to access
 *     property - The property of the engine to read. Often an element of <UDI_GFX_PROP>.
 *
 * out:
 *     return   - The amount of range segments returned by the driver
 */
int mglGetEngineRange(int index, unsigned int property)
{
    return requestrange(1, index, property);
}

/* Function: mglGetConnectorRange
 * Gets the valid range of values from a connector property.
 *
 * in:
 *     index    - The connector to access
 *     property - The property of the connector to read. Often an element of <UDI_GFX_PROP>.
 *
 * out:
 *     return   - The amount of range segments returned by the driver
 */
int mglGetConnectorRange(int index, unsigned int property)
{
    return requestrange(0, index, property);
}

