/* Summary: mglopen.c
 * Retrieving low level connector states
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <swgl/glxclient.h>
#include <GL/gl.h>
#include <mos/drivercom.h>
#include <mos.h>
#include <mos/gfx.h>

/* Function: mglOpen
 * Initialize the driver
 *
 * in:
 *     engines     - pointer to the number of engines
 *     connectors  - pointer to the number of connectors
 *
 * out:
 *     return      - zero on success, nonzero on failure
 *     *engines    - contains the number of engines
 *     *connectors - contains the number of connectors
 */
int mglOpen(unsigned int * engines, unsigned int * connectors)
{
    int outbuffer[4] = {GFXCOMMAND_BIND, 0};
    drv_sendmessage(_glx_messagedest, 8, (char *)outbuffer);

    int rcvlen = 0;
    while ((rcvlen = drv_peekmessage()) == 0)
    {
        yield();
    }
    if (rcvlen != 20) *(char *)(0x30006) = 0;
    
    int inbuffer[5];
    drv_readmessage((char*) inbuffer);
    *engines = inbuffer[3];
    *connectors = inbuffer[2];
    
    return inbuffer[4];
}
