/* Summary: mglsetconnector.c
 * Changing low level connector states
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <swgl/glxclient.h>
#include <GL/gl.h>
#include <mos/drivercom.h>
#include <mos/gfx.h>
#include <mos.h>

/* Function: mglSetConnectorState
 * Sets an graphics output connector state property
 *
 * in:
 *     index    - The connector to modify
 *     property - The property of the connector to modify. Often an element of <UDI_GFX_PROP>.
 *     value    - The new value for the property
 */
void mglSetConnectorState(int index, unsigned int property, int value)
{
    int buffer[5] = {GFXCOMMAND_SETCONNECTOR, 0, index, property, value};
    drv_sendmessage(_glx_messagedest, 20, (char *)buffer);
    
    int rcvlen = 0;
    while ((rcvlen = drv_peekmessage()) == 0)
    {
        yield();
    }
    if (rcvlen != 16) *(char*)0x30004 = 0;
    
    int inbuffer[5];
    drv_readmessage((char*) inbuffer);
}
