/* Summary: glxbegin.c
 * Wraps <glBegin> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glbeginstruct
{
    _glx_stream_header h;
    GLenum mode;
} glbeginstruct;

void glBegin(GLenum mode)
{
    glbeginstruct op;
    op.h.opcode = GLOP_BEGIN;
    op.h.len = 8;
    op.mode = mode;

    _glx_schedule(&op, op.h.len);
}
