/* Summary: glxbindbuffer.c
 * Wraps <glBindBufferUDI> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glbindbufferstruct
{
    _glx_stream_header h;
    GLenum target;
    GLuint buffer;
} glbindbufferstruct;

void glBindBufferUDI(GLenum target, GLuint buffer)
{
    glbindbufferstruct op;
    op.h.opcode = GLOP_BINDBUFFERUDI;
    op.h.len = 12;
    op.target = target;
    op.buffer = buffer;

    _glx_schedule(&op, op.h.len);
}
