/* Summary: glxclear.c
 * Wraps <glClear> into a GLX stream
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef struct glclearstruct
{
    _glx_stream_header h;
    GLbitfield mask;
} glclearstruct;

void glClear(GLbitfield mask)
{
    glclearstruct op;
    op.h.opcode = GLOP_CLEAR;
    op.h.len = 8;
    op.mask = mask;

    _glx_schedule(&op, op.h.len);
}
